/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    public static void rename(File file, String newName) {
        if (!file.exists()) {
            return;
        }
        if (StringUtils.equals((String)file.getName(), (String)newName)) {
            return;
        }
        String path = file.getParent();
        String newfileName = path + "/" + newName;
        File dest = new File(newfileName);
        if (dest.exists()) {
            dest.delete();
        }
        file.renameTo(dest);
    }

    public static String getFileName(File file) {
        if (!file.exists()) {
            return "";
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String getFileSuffix(File file) {
        if (!file.exists()) {
            return "";
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index, fileName.length());
    }

    public static List<File> findAllFileByRootPath(File rootPath) {
        if (!rootPath.exists()) {
            return Collections.emptyList();
        }
        if (!rootPath.isDirectory()) {
            return Lists.newArrayList((Object[])new File[]{rootPath});
        }
        ArrayList returnList = Lists.newArrayList();
        LinkedList list = Lists.newLinkedList();
        File[] files = rootPath.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.isDirectory()) {
                list.add(file);
                continue;
            }
            returnList.add(file);
        }
        while (!list.isEmpty()) {
            File tempFile = (File)list.removeFirst();
            files = tempFile.listFiles();
            for (File file : Objects.requireNonNull(files)) {
                if (file.isDirectory()) {
                    list.add(file);
                    continue;
                }
                returnList.add(file);
            }
        }
        return returnList;
    }

    public static String getLogRootPath() {
        String string;
        Reader reader = null;
        try {
            URL bootstrap = Thread.currentThread().getContextClassLoader().getResource("bootstrap.properties");
            if (bootstrap == null) {
                throw new RuntimeException("classPath://bootstrap.properties\u7f3a\u5931");
            }
            CharSource charSource = Resources.asCharSource((URL)bootstrap, (Charset)Charset.forName("utf-8"));
            reader = charSource.openStream();
            Properties properties = new Properties();
            properties.load(reader);
            String appName = properties.getProperty("spring.application.name");
            String usrHome = System.getProperty("user.home");
            string = usrHome + "/logs/" + appName;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }
}

