/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.elasticsearch;

import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.GetQuery;

public class ElasticsearchTemplate
extends org.springframework.data.elasticsearch.core.ElasticsearchTemplate {
    private Client client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;
    private String searchTimeout;

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, String searchTimeout) {
        super(client, elasticsearchConverter);
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        this.resultsMapper = new DefaultResultMapper(elasticsearchConverter.getMappingContext());
        this.searchTimeout = searchTimeout;
    }

    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        if (this.searchTimeout == null) {
            return (T)super.queryForObject(query, clazz, mapper);
        }
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetResponse response = (GetResponse)this.client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute().actionGet(this.searchTimeout);
        Object entity = mapper.mapResult(response, clazz);
        return (T)entity;
    }
}

