/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.alibaba.fastjson.JSON;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class DuibaDataSourceMonitor
implements DisposableBean {
    private boolean initted = false;
    private Map<String, BasicDataSource> dataSourceMap;
    private Map<String, PerfTestRoutingDataSource> routingDataSourceMap;
    private Thread duibaDataSourceMonitorThread;
    private static final long RETENTION_TIME = 1800000L;
    private Map<String, Map<Long, MonitorObj>> secondMonitorMap = new ConcurrentHashMap<String, Map<Long, MonitorObj>>();

    protected synchronized String getSecondMonitorJson() {
        return JSON.toJSONString(this.secondMonitorMap);
    }

    public synchronized void startMonitorThread(ApplicationContext context) {
        if (!this.initted) {
            this.initted = true;
            this.dataSourceMap = context.getBeansOfType(BasicDataSource.class);
            this.routingDataSourceMap = context.getBeansOfType(PerfTestRoutingDataSource.class);
            if (this.dataSourceMap.isEmpty() && this.routingDataSourceMap.isEmpty()) {
                return;
            }
            this.duibaDataSourceMonitorThread = new Thread(){

                @Override
                public void run() {
                    do {
                        for (Map.Entry entry : DuibaDataSourceMonitor.this.dataSourceMap.entrySet()) {
                            DuibaDataSourceMonitor.this.scanDataSource((String)entry.getKey(), (BasicDataSource)entry.getValue());
                        }
                        for (Map.Entry entry : DuibaDataSourceMonitor.this.routingDataSourceMap.entrySet()) {
                            DuibaDataSourceMonitor.this.scanDataSource((String)entry.getKey(), ((PerfTestRoutingDataSource)((Object)entry.getValue())).getOriginalDataSource());
                            DuibaDataSourceMonitor.this.scanDataSource((String)entry.getKey() + "_shade", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getShadeDataSource());
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    } while (!Thread.currentThread().isInterrupted());
                }
            };
            this.duibaDataSourceMonitorThread.start();
        }
    }

    private synchronized void scanDataSource(String key, BasicDataSource ds) {
        if (ds != null && !ds.isClosed()) {
            int numIdleConnections = ds.getNumIdle();
            int numActiveConnections = ds.getNumActive();
            int maxTotal = ds.getMaxTotal();
            LinkedHashMap<Long, MonitorObj> dbSecondMonitorMap = this.secondMonitorMap.get(key);
            if (dbSecondMonitorMap == null) {
                dbSecondMonitorMap = new LinkedHashMap<Long, MonitorObj>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, MonitorObj> eldest) {
                        return eldest.getKey() < System.currentTimeMillis() - 1800000L;
                    }
                };
                this.secondMonitorMap.putIfAbsent(key, (Map<Long, MonitorObj>)dbSecondMonitorMap);
            }
            dbSecondMonitorMap.put(System.currentTimeMillis(), new MonitorObj(numIdleConnections, numActiveConnections, maxTotal));
        }
    }

    public synchronized void destroy() throws Exception {
        if (this.duibaDataSourceMonitorThread != null) {
            this.duibaDataSourceMonitorThread.interrupt();
        }
    }

    public static class MonitorObj {
        private short numActive;
        private short numAllocated;
        private short maxTotal;

        public MonitorObj(int numIdleConnections, int numActiveConnections, int maxTotal) {
            this.numActive = (short)numActiveConnections;
            this.maxTotal = (short)maxTotal;
            this.numAllocated = (short)(numActiveConnections + numIdleConnections);
        }

        public MonitorObj() {
        }

        public short getNumActive() {
            return this.numActive;
        }

        public short getNumAllocated() {
            return this.numAllocated;
        }

        public short getMaxTotal() {
            return this.maxTotal;
        }
    }
}

