/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import com.coreos.jetcd.Client;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Conditional(value={OnEtcdEnabledCondition.class})
public @interface ConditionalOnEtcdEnabled {

    public static class OnEtcdEnabledCondition
    extends AllNestedConditions {
        public OnEtcdEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnClass(value={Client.class})
        static class FoundClass {
            FoundClass() {
            }
        }

        @ConditionalOnProperty(value={"duiba.cloud.etcd.enabled"}, matchIfMissing=true)
        static class FoundProperty {
            FoundProperty() {
            }
        }
    }
}

