/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duibaboot.ext.autoconfigure.etcd.ConditionalOnEtcdEnabled;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdLastRefreshStateEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.properties.EtcdProperties;
import com.coreos.jetcd.Client;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnEtcdEnabled
@EnableConfigurationProperties(value={EtcdProperties.class})
public class EtcdAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client etcdClient(EtcdProperties properties) {
        return Client.builder().endpoints(properties.getUris()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={EtcdKVClientDelegate.class})
    public EtcdKVClientDelegate etcdKVClientDelegate(Client etcdClient) {
        return new EtcdKVClientDelegate(etcdClient);
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class EtcdHealthConfig {
        protected EtcdHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(value="etcd")
        public EtcdEndpoint etcdEndpoint(Client etcdClient, EtcdProperties properties) {
            return new EtcdEndpoint(etcdClient, properties);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(value="etcdLastRefreshState")
        public EtcdLastRefreshStateEndpoint etcdLastRefreshStateEndpoint() {
            return new EtcdLastRefreshStateEndpoint();
        }
    }
}

