/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdLastRefreshStateEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdConfigProperties;
import com.coreos.jetcd.Client;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.data.KeyValue;
import com.coreos.jetcd.kv.GetResponse;
import com.coreos.jetcd.options.GetOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;

public class EtcdPropertySource
extends EnumerablePropertySource<Client> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdPropertySource.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private final String prefix;
    private final EtcdConfigProperties config;
    private static volatile Map<String, String> lastValidProperties = new HashMap<String, String>();

    public EtcdPropertySource(String root, Client source, EtcdConfigProperties config) {
        super(root, (Object)source);
        this.prefix = root.startsWith("/") ? root + "/" : "/" + root + "/";
        this.config = config;
    }

    public void init() {
        try {
            GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.fromString((String)this.prefix)).build();
            GetResponse response = (GetResponse)((Client)this.getSource()).getKVClient().get(ByteSequence.fromString((String)this.prefix), option).get(this.config.getTimeout(), this.config.getTimeoutUnit());
            if (response.getCount() > 0L) {
                this.process(response.getKvs());
            }
            EtcdLastRefreshStateEndpoint.markSuccess();
        }
        catch (Exception e) {
            logger.warn("Unable to init property source: " + this.getName(), (Throwable)e);
            EtcdLastRefreshStateEndpoint.markFail();
        }
        if (this.properties.size() == 0) {
            this.properties = lastValidProperties;
        } else {
            lastValidProperties = this.properties;
        }
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void process(List<KeyValue> kvs) {
        if (CollectionUtils.isEmpty(kvs)) {
            return;
        }
        for (KeyValue kv : kvs) {
            String key = kv.getKey().toStringUtf8();
            String value = kv.getValue().toStringUtf8();
            key = key.substring(this.prefix.length());
            this.properties.put(key.replace("/", "."), value);
        }
    }
}

