/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.gclog;

import cn.com.duiba.wolf.utils.DateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

public class GclogEndpoint
extends AbstractEndpoint<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GclogEndpoint.class);
    public static final String GCLOG_PATH = "/dev/shm";

    public GclogEndpoint() {
        super("gclog");
    }

    public Map<String, String> invoke() {
        File gcLogDir = new File(GCLOG_PATH);
        File[] gcFiles = gcLogDir.listFiles();
        if (gcFiles == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> gcFileMap = new HashMap<String, String>();
        for (File f : gcFiles) {
            String endTime;
            String startTime;
            if (f.isDirectory()) continue;
            try {
                startTime = this.getStartTime(f);
                endTime = this.getEndTime(f);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String key = String.format("%s-%s", startTime, endTime);
            gcFileMap.put(key, f.getAbsolutePath());
        }
        return gcFileMap;
    }

    private String getStartTime(File file) throws IOException {
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                try {
                    String string = this.parseTime(line);
                    return string;
                }
                catch (ParseException e) {
                    LOGGER.info("\u975e\u65f6\u95f4\u884c\u3002");
                }
            }
            throw new RuntimeException("gclog\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String getEndTime(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String parseTime(String line) throws ParseException {
        String timestamp = line.substring(0, 19);
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(timestamp);
        return DateUtils.getSecondStr((Date)date);
    }
}

