/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger;

import cn.com.duibaboot.ext.autoconfigure.core.utils.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class DockerApplicationLogRenameListener
implements SpringApplicationRunListener {
    private static Boolean IS_DORKER_ENV = Boolean.valueOf(System.getenv("RUN_IN_DOCKER"));
    private static AtomicBoolean IS_RUN_ED = new AtomicBoolean(false);
    private Pattern pattern = Pattern.compile("^[a-zA-Z]+\\.log$");

    public DockerApplicationLogRenameListener(SpringApplication application, String[] args) {
    }

    public void starting() {
        if (!IS_RUN_ED.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            return;
        }
        if (!IS_DORKER_ENV.booleanValue()) {
            return;
        }
        File logRootPath = new File(FileUtils.getLogRootPath());
        SimpleDateFormat minute = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        Date time = new Date();
        String timeStr = minute.format(time);
        List<File> fileList = FileUtils.findAllFileByRootPath(logRootPath);
        for (File file : fileList) {
            Matcher matcher = this.pattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            String fileName = FileUtils.getFileName(file);
            String fileSuffix = FileUtils.getFileSuffix(file);
            String newFileName = fileName + "_" + timeStr + fileSuffix;
            FileUtils.rename(file, newFileName);
        }
    }

    public void environmentPrepared(ConfigurableEnvironment configurableEnvironment) {
    }

    public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void finished(ConfigurableApplicationContext configurableApplicationContext, Throwable throwable) {
    }
}

