/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestUtils {
    private HttpRequestUtils() {
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        boolean isFromLocalIp = RequestTool.isLocalRequest((HttpServletRequest)request);
        if (!isFromLocalIp) {
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLocal;
    }

    public static boolean isLanRequest(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("x-forwarded-for"))) {
            return false;
        }
        String ip = RequestTool.getIpAddr((HttpServletRequest)request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp((String)ip)) {
            isLanIp = true;
        }
        if (!isLanIp) {
            return false;
        }
        boolean isUrlFromLan = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String urlHost = url.getHost();
            if (urlHost.equals("127.0.0.1") || urlHost.equals("localhost") || NetUtils.isLanIp((String)urlHost)) {
                isUrlFromLan = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLan;
    }
}

