/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.ClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreAsyncRestTemplateWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpAsyncClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRestTemplateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SsreBeanPostProcessor
implements BeanPostProcessor {
    private Logger logger = LoggerFactory.getLogger(SsreBeanPostProcessor.class);
    private final Set<String> whitePackages = Sets.newLinkedHashSet();
    private final Set<ClientWrapper> wrapperClassSet = Sets.newLinkedHashSet();
    private final Class[] acceptableClasses;

    public SsreBeanPostProcessor() {
        this.whitePackages.add("cn.com.duibaboot");
        this.whitePackages.add("org.springframework");
        this.whitePackages.add("org.mybatis");
        this.whitePackages.add("com.netflix");
        this.whitePackages.add("org");
        this.wrapperClassSet.add(new SsreHttpClientWrapper());
        this.wrapperClassSet.add(new SsreHttpAsyncClientWrapper());
        this.wrapperClassSet.add(new SsreRestTemplateWrapper());
        this.wrapperClassSet.add(new SsreAsyncRestTemplateWrapper());
        ArrayList<Class> acceptableClassesList = new ArrayList<Class>();
        for (ClientWrapper w : this.wrapperClassSet) {
            acceptableClassesList.add(w.acceptableClass());
        }
        this.acceptableClasses = acceptableClassesList.toArray(new Class[acceptableClassesList.size()]);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (!this.checkPackage(clazz.getPackage())) {
            return bean;
        }
        List<Field> fields = this.getFieldList(clazz);
        for (Field field : fields) {
            Class<?> fieldType;
            if (field.isAnnotationPresent(CanAccessInsideNetwork.class) || !this.isAcceptable(fieldType = field.getType())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(bean);
                for (ClientWrapper wrapper : this.wrapperClassSet) {
                    if (!wrapper.trySetClient(obj)) continue;
                    field.set(bean, wrapper);
                }
            }
            catch (Exception e) {
                this.logger.error("Client\u4ee3\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        return bean;
    }

    private boolean isAcceptable(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        for (Class c : this.acceptableClasses) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public void setWhitePackage(Set<String> whitePackage) {
        this.whitePackages.addAll(whitePackage);
    }

    private List<Field> getFieldList(Class clazz) {
        if (null == clazz) {
            return Collections.emptyList();
        }
        Object[] fields = clazz.getDeclaredFields();
        ArrayList fieldList = Lists.newArrayList((Object[])fields);
        Class superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        fieldList.addAll(this.getFieldList(superClass));
        return fieldList;
    }

    private boolean checkPackage(Package pakeage) {
        if (pakeage == null) {
            return false;
        }
        String packageName = pakeage.getName();
        for (String whitePackage : this.whitePackages) {
            if (!StringUtils.startsWith((CharSequence)packageName, (CharSequence)whitePackage)) continue;
            return false;
        }
        return true;
    }
}

