/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.event.EventListener;

public class WebContainerHealthIndicator
implements HealthIndicator {
    private static final Logger logger = LoggerFactory.getLogger(WebContainerHealthIndicator.class);
    private volatile boolean isWebContainerStarted;
    @Autowired
    private ApplicationInfoManager applicationInfoManager;

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void onEvent(EmbeddedServletContainerInitializedEvent event) {
        logger.error("set eureka status to UP");
        this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        this.isWebContainerStarted = true;
    }

    public Health health() {
        if (this.isWebContainerStarted) {
            return Health.up().build();
        }
        return Health.down((Exception)new IllegalStateException("web container have not started yet!")).build();
    }
}

