package cn.com.duibaboot.ext.autoconfigure.cat;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthRedisPlugin {

	@Autowired
	private Tracer tracer;
	@Autowired
	private ErrorParser errorParser;
	
	@Around("execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
	public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
		if(!tracer.isTracing() || !tracer.getCurrentSpan().isExportable()){
			return joinPoint.proceed();
		}

		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();

		Span span = tracer.createSpan("redis:/"+methodName);
		try {
			span.tag("redis.op", methodName);// get/...
			span.tag(Span.SPAN_LOCAL_COMPONENT_TAG_NAME, "redisClient");//本地组件名
			span.tag(Span.SPAN_PEER_SERVICE_TAG_NAME, "redis");//远程服务名
//            span.tag("peer.host", "www.duiba.com.cn:3306");//远程host
			if("get".equals(methodName)
					&& joinPoint.getArgs() != null
					&& joinPoint.getArgs().length == 1
					&& joinPoint.getArgs()[0] != null){
				span.tag("redis.key", joinPoint.getArgs()[0].toString());//key
			}
			span.logEvent(Span.CLIENT_SEND);

			return joinPoint.proceed();
		} catch(Exception e){
			errorParser.parseErrorTags(span, e);
			throw e;
		} finally {
			span.logEvent(Span.CLIENT_RECV);
			this.tracer.close(span);
		}
	}
	
}
