package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;

@Order(TraceFilter.ORDER+1)
public class DuibaTraceSecondFilter implements Filter {

    private Pattern skipPattern = Pattern.compile(SleuthWebProperties.DEFAULT_SKIP_PATTERN);

    private static Tracer tracer;

    @Autowired
    public void setTracer(Tracer tracer) {
        DuibaTraceSecondFilter.tracer = tracer;//NOSONAR
    }

    @Override
    public void init(FilterConfig filterConfig){
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }

        HttpServletRequest httpRequest = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        boolean skip = skipPattern.matcher(httpRequest.getRequestURI()).matches();
        if (!skip) {
            Span span = tracer.getCurrentSpan();
            String bagFlages = span.getBaggageItem(Span.SPAN_FLAGS);//
            String flages = (String) Optional.ofNullable(servletRequest.getAttribute(Span.SPAN_FLAGS)).orElse(Span.SPAN_NOT_SAMPLED);
            if(StringUtils.equalsIgnoreCase(Span.SPAN_SAMPLED,flages)||StringUtils.equalsIgnoreCase(Span.SPAN_SAMPLED,bagFlages)){
                span.setBaggageItem(Span.SPAN_FLAGS,Span.SPAN_SAMPLED);
                response.setHeader(Span.TRACE_ID_NAME,span.traceIdString());
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
        //do nothing
    }

    protected static Boolean isDebugMode(){
        if(tracer==null || !tracer.isTracing()){
            return false;
        }
        Span span = tracer.getCurrentSpan();
        String bagFlages = span.getBaggageItem(Span.SPAN_FLAGS);
        return StringUtils.equalsIgnoreCase(Span.SPAN_SAMPLED,bagFlages);
    }

}
