package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.sleuth.Span;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * 用于控制日志降级数据
 */
public class ZipkinRequest extends HttpServletRequestWrapper{
    public ZipkinRequest(HttpServletRequest request) {
        super(request);
    }

    private Boolean isDebugMode = false;


    @Override
    public String getHeader(String name) {

        if(isDebugMode && StringUtils.equalsIgnoreCase(name, Span.SPAN_FLAGS)){
            return Span.SPAN_SAMPLED;
        }
        return super.getHeader(name);
    }

    public void setDebugMode(Boolean debugMode) {
        isDebugMode = debugMode;
    }

}
