package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.hadoop.hbase.client.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.framework.ProxyFactory;

/**
 * hbase切面，监听hbase执行耗时，基于HbaseTemplate
 */
@Aspect
public class CatSpringDataHbaseAspect {

    private static final String space = "Hbase";

    @Around("execution(* org.apache.hadoop.hbase.client.HTableInterfaceFactory.createHTableInterface(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Table htable = (Table)joinPoint.proceed();

        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(htable);
        factory.addAdvice(new HbaseMethodInterceptor());
        return factory.getProxy();
    }

    /**
     * {@link MethodInterceptor}
     */
    private static class HbaseMethodInterceptor implements MethodInterceptor {

        HbaseMethodInterceptor() {
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            //忽略Object基类中的方法
            if(methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")){
                return invocation.proceed();
            }

            //只拦截指定方法
            if(methodName.equals("exists")
                    || methodName.equals("existsAll")
                    || methodName.equals("batch")
                    || methodName.equals("batchCallback")
                    || methodName.equals("get")
                    || methodName.equals("getScanner")
                    || methodName.equals("put")
                    || methodName.equals("checkAndPut")
                    || methodName.equals("delete")
                    || methodName.equals("checkAndDelete")
                    || methodName.equals("mutateRow")
                    || methodName.equals("append")
                    || methodName.equals("increment")
                    || methodName.equals("incrementColumnValue")) {
                return CatUtils.executeInCatTransaction(() -> invocation.proceed(), space, methodName);
            }

            return invocation.proceed();
        }

    }

}
