package cn.com.duibaboot.ext.autoconfigure.initserver;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.event.EventListener;

/**
 * 判断web容器有没有启动完成, 主要给EurekaClient使用，确保在web容器启动完成前，eureka状态不会改为UP, 以避免kong检测到UP状态的服务器直接放行流量导致访问不通的问题。
 */
public class WebContainerHealthIndicator implements HealthIndicator {

    private static final Logger logger = LoggerFactory.getLogger(WebContainerHealthIndicator.class);

    private volatile boolean isWebContainerStarted;

    @Autowired
    private ApplicationInfoManager applicationInfoManager;

    @EventListener(EmbeddedServletContainerInitializedEvent.class)
    public void onEvent(EmbeddedServletContainerInitializedEvent event){
        logger.error("set eureka status to UP"); // TODO info
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        isWebContainerStarted = true;
    }

    @Override
    public Health health() {
        if(isWebContainerStarted) {//表示web容器已经启动完成
            return Health.up().build();
        }else{
            return Health.down(new IllegalStateException("web container have not started yet!")).build();
        }
    }
}
