package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;


import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.named;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;


/**
 * 拦截jedis操作，如果是发送消息(publish)则发送到特殊channel中，以防影响正常逻辑。
 */
public class BinaryJedisInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "redis.clients.jedis.BinaryJedis";
    private static final String JEDIS_METHOD_INTERCET_CLASS = BinaryJedisMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return named("publish");
                }

                @Override
                public String getMethodsInterceptor() {
                    return JEDIS_METHOD_INTERCET_CLASS;
                }

                @Override public boolean isOverrideArgs() {
                    return true;
                }
            }
        };
    }
}
