package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;

import java.lang.reflect.Method;

/**
 * 拦截jedis操作，如果是发送消息(publish)则发送到特殊channel中，以防影响正常逻辑。
 */
public class BinaryJedisMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            if (method.getName().equals("publish")) {//压测消息发送到特殊的名为PerfTest的channel中（因为redis的消息发送和订阅会无视dbIndex标志）
                allArguments[0]="PerfTest".getBytes("UTF-8");
            }
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
