/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.ons;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.ons.OnsMessageListenerWrapper;
import cn.com.duibaboot.ext.autoconfigure.ons.OnsProperties;
import cn.com.duibaboot.ext.autoconfigure.ons.ProducerWrapper;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={Producer.class})
@EnableConfigurationProperties(value={OnsProperties.class})
public class OnsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OnsAutoConfiguration.class);

    private static class OnsConsumerFactoryBean
    extends EarlyClose
    implements FactoryBean<Consumer>,
    InitializingBean {
        @Autowired(required=false)
        @Qualifier(value="bootOnsMessageListener")
        private MessageListener onsMessageListener;
        private Consumer onsConsumer;
        private OnsProperties onsProperties;

        public OnsConsumerFactoryBean(OnsProperties onsProperties) {
            this.onsProperties = onsProperties;
        }

        public void afterPropertiesSet() throws Exception {
            String[] topicArr;
            if (this.onsMessageListener == null) {
                logger.error("", (Throwable)new IllegalStateException("bean id:[bootOnsMessageListener] class:[com.aliyun.openservices.ons.api.MessageListener] is not exist in spring's context, \u8bf7\u58f0\u660e\uff0c\u5426\u5219\u4e0d\u4f1a\u542f\u7528ons\u6d88\u8d39!!!,\u8bf7\u53c2\u8003\uff1a http://cf.dui88.com/pages/viewpage.action?pageId=4493915"));
                return;
            }
            Properties properties = new Properties();
            properties.put("ConsumerId", this.onsProperties.getConsumer().getGroup());
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("maxReconsumeTimes", this.onsProperties.getConsumer().getMaxReconsumeTimes());
            if (!StringUtils.isBlank((String)this.onsProperties.getNameSrvAddr())) {
                properties.put("NAMESRV_ADDR", this.onsProperties.getNameSrvAddr());
            }
            if (this.onsProperties.getConsumer().getConsumeThreadNums() > 0) {
                properties.put("ConsumeThreadNums", this.onsProperties.getConsumer().getConsumeThreadNums());
            }
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            String topics = this.onsProperties.getConsumer().getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*", this.onsMessageListener);
            }
            this.onsConsumer = consumer;
        }

        public Consumer getObject() throws Exception {
            return this.onsConsumer;
        }

        public Class<?> getObjectType() {
            return Consumer.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void stop() {
            if (this.onsConsumer != null) {
                this.onsConsumer.shutdown();
                this.awaitShutdown(this.onsConsumer, 3);
            }
        }

        private void awaitShutdown(Consumer onsConsumer, int awaitMaxSeconds) {
            Field fieldDefaultMQPushConsumer = ReflectionUtils.findField(onsConsumer.getClass(), (String)"defaultMQPushConsumer");
            fieldDefaultMQPushConsumer.setAccessible(true);
            Object defaultMQPushConsumer = ReflectionUtils.getField((Field)fieldDefaultMQPushConsumer, (Object)onsConsumer);
            Field fieldDefaultMQPushConsumerImpl = ReflectionUtils.findField(defaultMQPushConsumer.getClass(), (String)"defaultMQPushConsumerImpl");
            fieldDefaultMQPushConsumerImpl.setAccessible(true);
            Object defaultMQPushConsumerImpl = ReflectionUtils.getField((Field)fieldDefaultMQPushConsumerImpl, (Object)defaultMQPushConsumer);
            Field fieldConsumeMessageService = ReflectionUtils.findField(defaultMQPushConsumerImpl.getClass(), (String)"consumeMessageService");
            fieldConsumeMessageService.setAccessible(true);
            Object consumeMessageService = ReflectionUtils.getField((Field)fieldConsumeMessageService, (Object)defaultMQPushConsumerImpl);
            Field fieldConsumeExecutor = ReflectionUtils.findField(consumeMessageService.getClass(), (String)"consumeExecutor");
            fieldConsumeExecutor.setAccessible(true);
            ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)ReflectionUtils.getField((Field)fieldConsumeExecutor, (Object)consumeMessageService);
            try {
                consumeExecutor.awaitTermination(awaitMaxSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public int getPhase() {
            return 1;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Consumer.class})
    @ConditionalOnMissingBean(name={"onsConsumer"})
    @ConditionalOnProperty(name={"duiba.ons.consumer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsConsumerConfigurator
    extends OnsClientConfiguration {
        protected OnsConsumerConfigurator() {
        }

        @Bean
        public static SpecifiedBeanPostProcessor<MessageListener> onsMessageListenerPostProcessor() {
            return new SpecifiedBeanPostProcessor<MessageListener>(){

                @Override
                public Class<MessageListener> getBeanType() {
                    return MessageListener.class;
                }

                @Override
                public Object postProcessBeforeInitialization(MessageListener bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(MessageListener bean, String beanName) throws BeansException {
                    return new OnsMessageListenerWrapper(bean);
                }

                public int getOrder() {
                    return 0;
                }
            };
        }

        @Bean(name={"onsConsumer"})
        public FactoryBean<Consumer> onsConsumer() {
            return new OnsConsumerFactoryBean(this.onsProperties);
        }

        @EventListener(value={MainContextRefreshedEvent.class})
        @Order(value=0x7FFFFFFF)
        public void onEvent(MainContextRefreshedEvent event) {
            Map map = event.getApplicationContext().getBeansOfType(Consumer.class);
            if (!map.isEmpty()) {
                for (Consumer consumer : map.values()) {
                    if (consumer == null) continue;
                    consumer.start();
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Producer.class})
    @ConditionalOnMissingBean(name={"onsProducer"})
    @ConditionalOnProperty(name={"duiba.ons.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsProducerConfigurator
    extends OnsClientConfiguration {
        protected OnsProducerConfigurator() {
        }

        @Bean(name={"onsProducer"}, destroyMethod="shutdown")
        public Producer onsProducer() {
            Properties properties = new Properties();
            String producerId = this.onsProperties.getProducer().getGroup();
            if (producerId != null && !producerId.equals("")) {
                properties.put("ProducerId", producerId);
            }
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("SendMsgTimeoutMillis", this.onsProperties.getProducer().getSendMsgTimeoutMillis());
            if (!StringUtils.isBlank((String)this.onsProperties.getNameSrvAddr())) {
                properties.put("NAMESRV_ADDR", this.onsProperties.getNameSrvAddr());
            }
            Producer producer = ONSFactory.createProducer((Properties)properties);
            producer = new ProducerWrapper(producer);
            producer.start();
            return producer;
        }
    }

    protected static abstract class OnsClientConfiguration {
        @Autowired
        protected OnsProperties onsProperties;

        protected OnsClientConfiguration() {
        }
    }
}

