package cn.com.duibaboot.ext.autoconfigure.core;

import org.springframework.beans.BeansException;
import org.springframework.core.Ordered;

/**
 * 这个类的实例会被BeanPostProecessor调用,参见InitServerAutoConfiguration.specifiedBeanPostProcessorConfigurer
 * <br/>
 *
 * 注意，这个类的子类可以实现ApplicationContextAware来获得applicationContext，但是不能使用其他方法获得
 * Created by wenqi.huang on 2017/6/14.
 */
public interface SpecifiedBeanPostProcessor<T> extends Ordered {

    /**
     * 需要处理的Bean类
     * @return
     */
    Class<T> getBeanType();

    Object postProcessBeforeInitialization(T bean, String beanName) throws BeansException;

    Object postProcessAfterInitialization(T bean, String beanName) throws BeansException;

}
