package cn.com.duibaboot.ext.autoconfigure.perftest;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.connection.jedis.JedisConnection;

import javax.annotation.Resource;

/**
 * Created by guoyanfei .
 * 2018/11/2 .
 */
@Aspect
public class PerfTestSpringDataRedisPlugin {

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    @Around("execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            JedisConnection connection = (JedisConnection) joinPoint.proceed();
            perfTestFootMarker.markRedis(this.getHost(connection));
            return connection;
        }
        return joinPoint.proceed();
    }

    private String getHost(JedisConnection connection) {
        if (connection == null) {
            return null;
        }
        if (connection.getNativeConnection() == null) {
            return null;
        }
        if (connection.getNativeConnection().getClient() == null) {
            return null;
        }
        return connection.getNativeConnection().getClient().getHost();
    }
}
