package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordStartEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;

/**
 * trace从队列中取出来，写到文件中
 * Created by guoyanfei .
 * 2019-04-26 .
 */
@Slf4j
public class RecordTraceWriter {

    private volatile Thread traceWriteThread;

    @EventListener(RecordStartEvent.class)
    public void recordStartEventListener(RecordStartEvent event) {
        traceWriteThread = new Thread(new TraceWriteThread(RecordContextHolder.getRecordContext()));
        traceWriteThread.start();
    }

    @EventListener(RecordEndEvent.class)
    public void recordEndEventListener() {
        if (traceWriteThread != null) {
            traceWriteThread.interrupt();
        }
    }

    private class TraceWriteThread implements Runnable {

        private RecordContext context;

        private TraceWriteThread(RecordContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                writeTrace();
            } catch (Exception e) {
                log.error("writeTrace异常", e);
                RecordContextHolder.abnormalEnd("writeTrace异常:" + e.getMessage());
            }
        }

        private void writeTrace() {
            while (!context.isRecordFinished()) {
                // 时间到了，该结束了
                if (context.isTimeToEnd()) {
                    RecordContextHolder.normalEnd();
                    continue;
                }

                try {
                    FlowReplayTrace trace = context.pollTrace();
                    if (trace == null) {
                        continue;
                    }
                    context.writeTrace(trace);
                    // 文件大小到了，该结束了
                    if (context.isFileSizeToEnd()) {
                        RecordContextHolder.normalEnd();
                    }
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                } catch (Exception e) {
                    log.error("单个用例写入异常", e);
                }
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
            }
        }
    }
}
