package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 流量录制配置的实体类
 * Created by guoyanfei .
 * 2019-01-23 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RecordConfigDto implements Serializable {

    private static final long serialVersionUID = -4778640379274477988L;

    /**
     * 用例集id
     */
    private Long usecaseSetId;

    /**
     * 录制文件最大大小，单位M
     */
    private Integer maxFileSize;

    /**
     * 录制文件最大分钟数，单位分钟
     */
    private Integer maxMinutes;

    /**
     * 参数是否合法
     * @return
     */
    public boolean isLegal() {
        return usecaseSetId != null && maxFileSize != null && maxMinutes != null;
    }

    @Override
    public String toString() {
        return "FlowRecordConfigDto{" + "usecaseSetId=" + usecaseSetId + ", maxFileSize=" + maxFileSize + ", maxMinutes=" + maxMinutes + '}';
    }
}
