package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import mockit.Mock;
import mockit.MockUp;
import mockit.internal.startup.Startup;
import net.bytebuddy.agent.ByteBuddyAgent;

/**
 * 此类用于返回模拟的时间，会影响System.currentTimeMillis()、new Date()等调用，这个类仅供回放使用。
 */
public class ReplayClockMockSupport {

	// runs before the mock is applied
	private static final long REAL_START_MILLIS = System.currentTimeMillis();//真实的初始化时间
	private static final long REAL_START_NANOS = System.nanoTime();
	/**
	 * 模拟的相对时间偏移量，单位ms，负数表示过去，正数表示未来，0表示使用当前时间
	 */
	private static volatile long OFFSET_MILLIS = 0L;

	static{
		if(FlowReplayUtils.isReplayEnv()){
			Startup.premain(null, ByteBuddyAgent.install());
			init();
		}
	}

	private static void init() {
		MockUp<System> systemMockUp = new MockUp<System>(){
			//覆盖System同名方法
			@Mock
			public long currentTimeMillis(){
				return millisSinceClassInit() + REAL_START_MILLIS + OFFSET_MILLIS;
			}

		};
	}

	/**
	 * 从系统启动到当前经过的真实ms数
	 * @return
	 */
	private static long millisSinceClassInit() {
		return (System.nanoTime() - REAL_START_NANOS) / 1000000;
	}

	/**
	 * 设置时间偏移量，单位ms，比如这里设置 -1000，则每次调用System.currentTimeMillis()返回的时间都比真实时间少1秒. 设置为0则没有偏移
	 * @param offsetMillis
	 */
	public static void setOffsetMillis(long offsetMillis){
		ReplayClockMockSupport.OFFSET_MILLIS = offsetMillis;
	}

}
