package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;

/**
 * 实例的回放上下文 持有者
 * Created by guoyanfei .
 * 2019-02-26 .
 */
public class ReplayContextHolder {

    private ReplayContextHolder() {
    }

    private static volatile boolean replaying = false;

    private static volatile ReplayContext replayContext;

    /**
     * 当前实例是否在回放中
     * @return
     */
    public static boolean isReplaying() {
        return replaying && (replayContext != null);
    }

    /**
     * 开始回放
     * @param replayConfig
     */
    public synchronized static void start(ReplayConfigDto replayConfig) {
        if (!replaying) {
            replaying = true;
            replayContext = new ReplayContext(replayConfig);
            replayContext.start();
            ReplayClockMockSupport.setOffsetMillis(replayConfig.getStartTime() - replayContext.getStartTime());
            MainApplicationContextHolder.getApplicationContext().publishEvent(new ReplayStartEvent());
        } else {
            throw new FlowReplayException("回归操作已经开始_请勿重复开始");
        }
    }

    /**
     * 结束回放
     */
    public synchronized static void end() {
        if (replaying) {
            replaying = false;
            ReplayClockMockSupport.setOffsetMillis(0);
            replayContext.end();
            MainApplicationContextHolder.getApplicationContext().publishEvent(new ReplayEndEvent());
        } else {
            throw new FlowReplayException("回归操作已经结束_请勿重复结束");
        }
    }

    /**
     * 强制结束回放
     */
    public static void forceEnd() {
        replayContext.tracesLoadFinish();
        replayContext.replayersDone();
        end();
    }

    /**
     * 获取当前实例的回放上下文
     * @return
     */
    public static ReplayContext getReplayContext() {
        return replayContext;
    }

}
