/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayTraceContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceContext.class);
    private static final long serialVersionUID = 2716578641071393051L;
    private String traceId;
    private FlowReplaySpan mainSpan;
    private LinkedBlockingQueue<FlowReplaySpan> subSpans;
    private boolean errorMarked;
    private FlowReplayErrorMsgTypeEnum errorMsgType;
    private String errorMsgDetail;

    public static void create(FlowReplayTrace trace) {
        ReplayTraceContext c = new ReplayTraceContext();
        c.traceId = trace.getTraceId();
        c.mainSpan = trace.getMainSpan();
        c.subSpans = new LinkedBlockingQueue<FlowReplaySpan>(trace.getSubSpans());
        c.errorMarked = false;
        c.errorMsgType = null;
        c.errorMsgDetail = null;
        ThreadLocalHolder.threadLocal2ReplayTraceContext.set(c);
        ReplayTraceContext.traceLog(c);
    }

    private static void traceLog(ReplayTraceContext c) {
        if (log.isDebugEnabled()) {
            ArrayList<String> subSpanTypes = new ArrayList<String>();
            for (FlowReplaySpan span : c.subSpans) {
                subSpanTypes.add(span.getSpanType().toString());
            }
            log.debug("Replay_TraceId_{}_MainSpanType_{}_SubSpanTypes_{}", new Object[]{c.traceId, c.mainSpan.getSpanType(), Joiner.on((String)"|").join(subSpanTypes)});
        }
    }

    private static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, String expert, String actual, Throwable t) {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null || c.errorMarked) {
            return;
        }
        c.errorMarked = true;
        c.errorMsgType = errorMsgType;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)expert) || StringUtils.isNotBlank((CharSequence)actual)) {
            sb.append(String.format("\u671f\u671b: %s, \u5b9e\u9645: %s \n", expert, actual));
        }
        sb.append(ExceptionUtils.getStackTrace((Throwable)(t != null ? t : new Exception())));
        c.errorMsgDetail = sb.toString();
    }

    private static String getDuibaStackTrace(Throwable t) {
        String[] stackFrames = ExceptionUtils.getStackFrames((Throwable)t);
        StringBuilder sb = new StringBuilder();
        for (String it : stackFrames) {
            if (it.startsWith("\tat ") && !it.startsWith("\tat cn.com.duiba")) continue;
            sb.append(it);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType) {
        ReplayTraceContext.markError(errorMsgType, null, null, null);
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, String expert, String actual) {
        ReplayTraceContext.markError(errorMsgType, expert, actual, null);
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, Throwable t) {
        ReplayTraceContext.markError(errorMsgType, null, null, t);
    }

    public static FlowReplaySpan pollSubSpan() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null || c.subSpans == null) {
            return null;
        }
        return c.subSpans.poll();
    }

    public static ReplayTraceContext getAndRemove() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        ThreadLocalHolder.threadLocal2ReplayTraceContext.remove();
        return c;
    }

    public static ReplayTraceContext get() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        return c;
    }

    public static String getContextTraceId() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        return c.traceId;
    }

    public static void remove() {
        ThreadLocalHolder.threadLocal2ReplayTraceContext.remove();
    }

    public static boolean isReplaying() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        return c != null;
    }

    public static String getCompletedErrorMsg() {
        ReplayTraceContext c = (ReplayTraceContext)ThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        if (c.errorMsgType == null) {
            return null;
        }
        return c.errorMsgType.desc() + ",traceId=" + c.traceId + "," + c.errorMsgDetail;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public FlowReplaySpan getMainSpan() {
        return this.mainSpan;
    }

    public LinkedBlockingQueue<FlowReplaySpan> getSubSpans() {
        return this.subSpans;
    }

    public boolean isErrorMarked() {
        return this.errorMarked;
    }

    public FlowReplayErrorMsgTypeEnum getErrorMsgType() {
        return this.errorMsgType;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getErrorMsgDetail() {
        return this.errorMsgDetail;
    }

    private static class ThreadLocalHolder {
        private static final ThreadLocal<ReplayTraceContext> threadLocal2ReplayTraceContext = new ThreadLocal();

        private ThreadLocalHolder() {
        }
    }
}

