/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceResultWriter {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceResultWriter.class);
    private volatile Thread traceResultWriteThread;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        this.traceResultWriteThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    ReplayTraceResultWriter.this.writeTraceResult(context);
                }
                catch (Exception e) {
                    log.error("\u5f15\u6d41\u56de\u5f52_\u56de\u653e\u7ed3\u679c\u5199\u6587\u4ef6\u5f02\u5e38_reportId_{}", (Object)context.getReportId(), (Object)e);
                    ReplayContextHolder.forceEnd();
                }
            }
        }, "DBThread-Replay-\u5199\u56de\u653e\u7ed3\u679c");
        this.traceResultWriteThread.start();
    }

    @EventListener(value={ReplayEndEvent.class})
    public void replayEndEventListener(ReplayEndEvent event) {
        if (this.traceResultWriteThread != null) {
            this.traceResultWriteThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTraceResult(ReplayContext context) throws IOException {
        File file = new File("/data/flowreplay/replay_result");
        RandomAccessFile raf = null;
        try {
            while (!context.isReplayersDone() || !context.isResultQueueEmpty()) {
                try {
                    ReplayTraceResult result = context.pollResult();
                    if (result == null) continue;
                    if (raf == null) {
                        raf = new RandomAccessFile(file, "rw");
                        raf.writeInt(1);
                        raf.writeInt(0);
                    }
                    byte[] resultBytes = Hessian2Serializer.serialize(result);
                    raf.writeInt(resultBytes.length);
                    raf.write(resultBytes);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        finally {
            IOUtils.closeQuietly(raf);
            ReplayContextHolder.end();
        }
    }
}

