/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RandomFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayRandomMethodInterceptor
implements StaticMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayRandomMethodInterceptor.class);

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("Random\u56de\u653e_traceId={}_spanType={}_spanId={}", new Object[]{ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null});
        if (span == null || SpanType.RANDOM != span.getSpanType()) {
            String expert = SpanType.RANDOM.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RandomFlowReplaySpan randomSpan = (RandomFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(randomSpan.getMethodName(), method)) {
            String expert = randomSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_602, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(randomSpan.getParameterTypes(), parameterTypes)) {
            String expert = FlowReplayUtils.stringArrayToString(randomSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(parameterTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_600, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            if (!FlowReplayUtils.isArgumentsEqual(randomSpan.getParameterValues(), allArguments)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_601);
                throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_603, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            result.defineReturnValue(randomSpan.getReturnValue());
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_604, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    @Override
    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        return ret;
    }

    @Override
    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }
}

