/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.Kryo;
import shaded.com.esotericsoftware.kryo.io.Input;
import shaded.com.esotericsoftware.kryo.io.Output;

public class KryoSerializer {
    private static final Logger log = LoggerFactory.getLogger(KryoSerializer.class);
    private static final int BUFFER_SIZE = 16384;
    private static ThreadLocal<Kryo> kryoThreadLocal = ThreadLocal.withInitial(() -> new Kryo());

    private KryoSerializer() {
    }

    public static Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Input input = new Input(in, 16384);
        Object obj = kryo.readClassAndObject(input);
        input.close();
        return obj;
    }

    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output(out, 16384);
        kryo.writeClassAndObject(output, object);
        output.close();
        return out.toByteArray();
    }
}

