/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.factory;

import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.DuibaThreadPoolConfig;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ThreadPoolFactoryBean
implements FactoryBean<ThreadPoolExecutorWrapper> {
    @Autowired
    private DuibaThreadPoolConfig duibaThreadPoolConfig;
    private String threadPoolName;

    public ThreadPoolExecutorWrapper getObject() {
        Objects.requireNonNull(this.threadPoolName);
        Map<String, ThreadPoolProperties> extra = this.duibaThreadPoolConfig.getExtra();
        ThreadPoolProperties properties = StringUtils.equals((String)this.threadPoolName, (String)"executorService") ? this.duibaThreadPoolConfig.getDefaultThreadPoolProperties() : extra.get(this.threadPoolName);
        if (properties == null) {
            throw new IllegalArgumentException("\u7f3a\u5931\u7ebf\u7a0b\u6c60" + this.threadPoolName + "\u7684\u914d\u7f6e");
        }
        return new ThreadPoolExecutorWrapper(this.threadPoolName, properties);
    }

    public Class<?> getObjectType() {
        return ThreadPoolExecutorWrapper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }
}

