/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.container;

import cn.com.duibaboot.ext.autoconfigure.core.DuibaServerProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorRunnable;
import cn.com.duibaboot.ext.autoconfigure.web.container.EmbeddedServletContainerThreadPoolHolder;
import cn.com.duibaboot.ext.autoconfigure.web.container.SpecifiedEmbeddedServletContainerCustomizer;
import io.undertow.Undertow;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowCustomizer
extends SpecifiedEmbeddedServletContainerCustomizer<UndertowEmbeddedServletContainerFactory> {
    private static volatile DuibaServerProperties duibaServerProperties;
    private volatile XnioWorker xnioWorker;

    public UndertowCustomizer(DuibaServerProperties duibaServerProperties) {
        super(UndertowEmbeddedServletContainerFactory.class);
        UndertowCustomizer.duibaServerProperties = duibaServerProperties;
    }

    @Override
    public void customizeSpecified(UndertowEmbeddedServletContainerFactory container) {
        container.addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

            public void customize(Undertow.Builder builder) {
                try {
                    int ioThreads = (Integer)FieldUtils.readDeclaredField((Object)builder, (String)"ioThreads", (boolean)true);
                    int workerThreads = (Integer)FieldUtils.readDeclaredField((Object)builder, (String)"workerThreads", (boolean)true);
                    OptionMap.Builder workerOptions = (OptionMap.Builder)FieldUtils.readDeclaredField((Object)builder, (String)"workerOptions", (boolean)true);
                    Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
                    XnioWorker worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, ioThreads).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, workerThreads).set(Options.WORKER_TASK_MAX_THREADS, workerThreads).set(Options.TCP_NODELAY, true).set(Options.CORK, true).addAll(workerOptions.getMap()).getMap());
                    builder.setWorker(worker);
                    UndertowCustomizer.this.xnioWorker = worker;
                    Field taskPoolField = FieldUtils.getDeclaredField(XnioWorker.class, (String)"taskPool", (boolean)true);
                    ThreadPoolExecutor httpExecutor = (ThreadPoolExecutor)taskPoolField.get(worker);
                    EmbeddedServletContainerThreadPoolHolder.setServletContainerThreadPool(httpExecutor);
                    EmbeddedServletContainerThreadPoolHolder.setServletContainerType(EmbeddedServletContainerThreadPoolHolder.ServletContainerType.UNDERTOW);
                    if (duibaServerProperties.isInternalMode()) {
                        UndertowCustomizer.this.failFastToHttpExecutor(httpExecutor);
                    }
                }
                catch (IOException | IllegalAccessException e) {
                    throw new RuntimeException("[NOTIFYME] will never be here", e);
                }
            }
        }});
    }

    @Override
    public void shutdownGracefully() {
        if (this.xnioWorker != null) {
            this.xnioWorker.shutdown();
            try {
                this.xnioWorker.awaitTermination(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.xnioWorker.isTerminated()) {
                this.xnioWorker.shutdownNow();
            }
            this.xnioWorker = null;
        }
    }

    private static class XnioWorkerMethodInterceptor
    implements MethodInterceptor {
        private XnioWorkerMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method m = invocation.getMethod();
            if (m.getName().equals("execute")) {
                Runnable runnable = (Runnable)invocation.getArguments()[0];
                runnable = new MonitorRunnable(runnable);
                invocation.getArguments()[0] = runnable;
                return invocation.proceed();
            }
            return invocation.proceed();
        }
    }
}

