package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;

/**
 * 自定义的callback span类型。
 * Created by guoyanfei .
 * 2019-05-23 .
 */
public class CustomizeCallbackFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = -3774294652846729094L;

    /**
     * span的标志key
     */
    private String key;

    /**
     * 返回值
     */
    private byte[] returnValue;

    @Override
    public SpanType getSpanType() {
        return SpanType.CUSTOMIZE;
    }

    /**
     * 创建span
     * @param key
     * @param ret
     * @return
     */
    public static CustomizeCallbackFlowReplaySpan createSpan(String key, Object ret) {
        CustomizeCallbackFlowReplaySpan span = new CustomizeCallbackFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.key = key;
        span.returnValue = KryoSerializer.serialize(ret);
        return span;
    }

    public String getKey() {
        return key;
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }

}
