package cn.com.duibaboot.ext.autoconfigure.flowreplay;

/**
 * 回放失败枚举
 * Created by guoyanfei .
 * 2019-02-27 .
 */
public enum FlowReplayErrorMsgTypeEnum {

    EM_001(1, "执行失败: 由于接口内部调用内容有变动，无法回归"),
    EM_002(2, "执行失败: 由于接口内部增加了新的RPC调用，无法回归"),
    EM_010(10, "执行失败: 调用接口报错：Connection timed out，可能是引流回归平台设计缺陷，请联系中台确认"),

    EM_100(100, "执行失败: redis调用参数类型不一致"),
    EM_101(101, "执行失败: redis调用参数值不一致"),
    EM_102(102, "执行失败: redis调用方法名称不一致"),
    EM_103(103, "执行失败: redis调用方法参数值反序列化失败"),
    EM_104(104, "执行失败: redis调用方法返回值反序列化失败"),
    EM_105(105, "执行失败: redis调用方法返回值类型不一致"),
    EM_106(106, "执行失败: redis调用方法所在类不一致"),

    EM_201(201, "执行失败: feign调用方法名称不一致"),
    EM_202(202, "执行失败: feign调用方法参数类型不一致"),
    EM_203(203, "执行失败: feign调用方法参数值不一致"),
    EM_204(204, "执行失败: feign调用方法返回值类型不一致"),
    EM_205(205, "执行失败: feign调用方法所在类不一致"),
    EM_206(206, "执行失败: feign调用方法参数值反序列化失败"),
    EM_207(207, "执行失败: feign调用方法返回值反序列化失败"),

    EM_300(300, "执行失败: RemoteService调用方法参数类型不存在"),

    EM_400(400, "执行失败: guava cache调用参数类型不一致"),
    EM_401(401, "执行失败: guava cache调用参数值不一致"),
    EM_402(402, "执行失败: guava cache调用方法名称不一致"),
    EM_403(403, "执行失败: guava cache调用方法参数值反序列化失败"),
    EM_404(404, "执行失败: guava cache调用方法返回值反序列化失败"),

    EM_500(500, "执行失败: caffeine cache调用参数类型不一致"),
    EM_501(501, "执行失败: caffeine cache调用参数值不一致"),
    EM_502(502, "执行失败: caffeine cache调用方法名称不一致"),
    EM_503(503, "执行失败: caffeine cache调用方法参数值反序列化失败"),
    EM_504(504, "执行失败: caffeine cache调用方法返回值反序列化失败"),

    EM_600(600, "执行失败: random调用参数类型不一致"),
    EM_601(601, "执行失败: random调用参数值不一致"),
    EM_602(602, "执行失败: random调用方法名称不一致"),
    EM_603(603, "执行失败: random调用方法参数值反序列化失败"),
    EM_604(604, "执行失败: random调用方法返回值反序列化失败"),

    EM_701(701, "执行失败: 自定义span调用方法名称不一致"),
    EM_702(702, "执行失败: 自定义span调用方法参数类型不一致"),
    EM_703(703, "执行失败: 自定义span调用方法参数值不一致"),
    EM_704(704, "执行失败: 自定义span调用方法返回值类型不一致"),
    EM_705(705, "执行失败: 自定义span调用方法所在类不一致"),
    EM_706(706, "执行失败: 自定义span调用方法参数值反序列化失败"),
    EM_707(707, "执行失败: 自定义span调用方法返回值反序列化失败"),

    EM_800(800, "执行失败: 自定义callback span调用key不一致");

    FlowReplayErrorMsgTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private int code;

    private String desc;

    public int code() {
        return code;
    }

    public String desc() {
        return desc;
    }
}
