package cn.com.duibaboot.ext.autoconfigure.logger;

import ch.qos.logback.classic.PatternLayout;
import cn.com.duibaboot.ext.autoconfigure.logger.logback.ThreadAndPerfTestConverter;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 注册logback pattern，在线程名后面附加 :Perf 标记，表示当前线程在压测
 * 同时在线程名后面附加sleuth分布式追踪的相关信息:tradeId,spanId,exportable
 * <br/>
 * 作用2：LogbackLoggingSystem会在/refresh的时候重新加载，导致kafka log、accesslog等失效（并且重新加载期间日志打印会有问题）。禁止logback重新加载
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class LoggingAppListener implements ApplicationListener<ApplicationStartingEvent> {

    private boolean called = false;

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
        if(called){
            return;
        }
        //注册logback pattern，在线程名后面附加[Perf]标记，表示当前线程在压测

        PatternLayout patternLayout = new PatternLayout();
        //这里看起来好像注册到了一个对象里，实际上内部的defaultConverterMap是static的，会全局生效
        patternLayout.getDefaultConverterMap().put("t", ThreadAndPerfTestConverter.class.getName());
        patternLayout.getDefaultConverterMap().put("thread", ThreadAndPerfTestConverter.class.getName());

        called = true;

        //设置自定义LoggingSystem的类名
        //LogbackLoggingSystem会在/refresh的时候重新加载，导致kafka log、accesslog等失效（并且重新加载期间日志打印会有问题）。禁止logback重新加载
        System.setProperty(LoggingSystem.SYSTEM_PROPERTY, NonRefreshLogbackLoggingSystem.class.getName());
    }

}
