package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;
import java.util.concurrent.Future;

/**
 * CloseableHttpAsyncClient的包装类，让CloseableHttpAsyncClient支持线上压测。
 */
public class HttpAsyncClientWrapper extends CloseableHttpAsyncClient {

    private CloseableHttpAsyncClient original;

    public HttpAsyncClientWrapper(CloseableHttpAsyncClient original){
        this.original = original;
    }

    private <T> FutureCallback<T> getPerfTestWrappedCallback(FutureCallback<T> callback){
        final boolean isCurrentInPerfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        final String currentPerfTestSceneId = InternalPerfTestContext.getCurrentSceneId();
        final boolean isTestCluster = InternalPerfTestContext.isTestCluster();
        FutureCallback<T> wrappedCallback = new FutureCallback<T>() {
            @Override
            public void completed(T result) {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest(currentPerfTestSceneId, isTestCluster);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.completed(result);
                } finally {
                    InternalPerfTestContext.markAsNormal();
                }
            }

            @Override
            public void failed(Exception ex) {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest(currentPerfTestSceneId, isTestCluster);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.failed(ex);
                }finally{
                    InternalPerfTestContext.markAsNormal();
                }
            }

            @Override
            public void cancelled() {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest(currentPerfTestSceneId, isTestCluster);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.cancelled();
                }finally{
                    InternalPerfTestContext.markAsNormal();
                }
            }
        };
        return wrappedCallback;
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return original.execute(requestProducer, responseConsumer, context, getPerfTestWrappedCallback(callback));
    }

    @Override
    public boolean isRunning() {
        return original.isRunning();
    }

    @Override
    public void start() {
        original.start();
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return original.execute(requestProducer, responseConsumer, getPerfTestWrappedCallback(callback));
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return original.execute(target, request, context, getPerfTestWrappedCallback(callback));
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return original.execute(target, request, getPerfTestWrappedCallback(callback));
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return original.execute(request, context, getPerfTestWrappedCallback(callback));
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return original.execute(request, getPerfTestWrappedCallback(callback));
    }

    @Override
    public void close() throws IOException {
        original.close();
    }
}
