/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaHystrixCommandExecutionHook
extends HystrixCommandExecutionHook {
    private static final Logger logger = LoggerFactory.getLogger(DuibaHystrixCommandExecutionHook.class);

    public <T> Exception onFallbackError(HystrixInvokable<T> commandInstance, Exception e) {
        return super.onFallbackError(commandInstance, e);
    }

    public <T> void onFallbackSuccess(HystrixInvokable<T> commandInstance) {
        HystrixCommand c;
        Throwable e;
        if (commandInstance instanceof HystrixCommand && (e = (c = (HystrixCommand)commandInstance).getExecutionException()) != null) {
            logger.warn("hystrix group:{}, key:{} execute failed and entered fallback", new Object[]{c.getCommandGroup().name(), c.getCommandKey().name(), e});
        }
    }
}

