/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.CustomizeFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RecordCustomizeFlowReplaySpanAspect {
    private static final Logger log = LoggerFactory.getLogger(RecordCustomizeFlowReplaySpanAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *.*(..)) && @annotation(cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan)")
    public Object customizeSpanRecordAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Object ret;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        FlowReplayCustomizeSpan customizeSpan = signature.getMethod().getAnnotation(FlowReplayCustomizeSpan.class);
        if (customizeSpan == null || !FlowReplayTrace.isTraced()) {
            return joinPoint.proceed();
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return joinPoint.proceed();
        }
        Method method = signature.getMethod();
        Object[] parameterValues = joinPoint.getArgs();
        Object obj = joinPoint.getTarget();
        IgnoreSubInvokesContext.instMark(obj, method, parameterValues);
        try {
            ret = joinPoint.proceed();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            throw t;
        }
        try {
            CustomizeFlowReplaySpan span = CustomizeFlowReplaySpan.createSpan(signature, parameterValues, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("Customize\u5f55\u5236_traceId={}_spanId={}", (Object)span.getTraceId(), (Object)span.getSpanId());
        }
        catch (Throwable t) {
            log.error("Customize_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }
}

