/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpringMvcFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyWriterHttpServletResponseWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerMapping;

public class RecordSpringMvcFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RecordSpringMvcFilter.class);
    private static final long MAX_CONTENT_LENGTH = 0xA00000L;
    @Resource
    private RecordSampler recordSampler;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        SpringMvcFlowReplaySpan mainSpan = null;
        BodyReaderHttpServletRequestWrapper requestWrapper = null;
        BodyWriterHttpServletResponseWrapper responseWrapper = null;
        if (this.canRecord(req)) {
            requestWrapper = new BodyReaderHttpServletRequestWrapper(req);
            responseWrapper = new BodyWriterHttpServletResponseWrapper(resp);
            try {
                mainSpan = SpringMvcFlowReplaySpan.createSpan((HttpServletRequest)requestWrapper);
                FlowReplayTrace.createTrace(mainSpan);
                mainSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
            }
            catch (Exception e) {
                log.error("SpringMvcFlowReplaySpan_createSpan_error", (Throwable)e);
            }
            IgnoreSubInvokesContext.unmark();
        }
        try {
            chain.doFilter((ServletRequest)(requestWrapper == null ? req : requestWrapper), (ServletResponse)(responseWrapper == null ? resp : responseWrapper));
            this.tryStoreTrace(mainSpan, requestWrapper, responseWrapper);
        }
        catch (Throwable throwable) {
            this.tryStoreTrace(mainSpan, requestWrapper, responseWrapper);
            throw throwable;
        }
    }

    private boolean canRecord(HttpServletRequest request) {
        if (!RecordContextHolder.isRecording()) {
            return false;
        }
        if (this.isFeignRequest(request)) {
            return false;
        }
        if (FlowReplayConstants.HTTP_EXCLUDE_URI.contains(request.getRequestURI())) {
            return false;
        }
        if (!this.canRequestContentRecord(request)) {
            return false;
        }
        return this.recordSampler.isSampled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStoreTrace(SpringMvcFlowReplaySpan mainSpan, BodyReaderHttpServletRequestWrapper requestWrapper, BodyWriterHttpServletResponseWrapper responseWrapper) {
        if (requestWrapper == null || responseWrapper == null) {
            return;
        }
        try {
            DBTimeProfile.setCurrentThreshold((int)1000000);
            byte[] responseBody = responseWrapper.getResponseBody();
            if (this.canResponseContentRecord((HttpServletResponse)responseWrapper, responseBody)) {
                RecordContext context = RecordContextHolder.getRecordContext();
                if (context == null || mainSpan == null) {
                    return;
                }
                mainSpan.setResponseBody(responseBody);
                mainSpan.setSpringBestMatchingUri((String)requestWrapper.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE));
                FlowReplayTrace trace = FlowReplayTrace.get();
                if (trace != null) {
                    context.offerTrace(trace);
                }
            }
        }
        catch (Throwable t) {
            log.error("tryStoreTrace_error", t);
        }
        finally {
            FlowReplayTrace.remove();
        }
    }

    private boolean canResponseContentRecord(HttpServletResponse response, byte[] responseBody) {
        String contentType = response.getContentType();
        if (contentType == null || contentType.contains("text/plain")) {
            return FlowReplayUtils.isJSONValid(new String(responseBody, StandardCharsets.UTF_8));
        }
        return contentType.contains("application/json");
    }

    private boolean canRequestContentRecord(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        if (contentType == null) {
            return true;
        }
        String contentLengthStr = request.getHeader("Content-Length");
        long contentLength = StringUtils.isBlank((CharSequence)contentLengthStr) ? 0L : Long.valueOf(contentLengthStr);
        return !contentType.contains("multipart/form-data") && contentLength <= 0xA00000L;
    }

    private boolean isFeignRequest(HttpServletRequest request) {
        return "true".equals(request.getHeader("X-Rpc"));
    }

    public void destroy() {
    }
}

