/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class PercentageBasedRecordSampler
implements RecordSampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private volatile BitSet sampleDecisions;
    private volatile float percentage;

    public PercentageBasedRecordSampler() {
        this.init(Float.valueOf(0.01f));
    }

    public void init(Float percentage) {
        if (percentage == null) {
            return;
        }
        this.percentage = percentage.floatValue();
        int outOf10000 = (int)(this.percentage * 10000.0f);
        this.sampleDecisions = PercentageBasedRecordSampler.randomBitSet(10000, outOf10000, new Random());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSampled() {
        if (this.percentage == 0.0f) {
            return false;
        }
        if (this.percentage == 1.0f) {
            return true;
        }
        PercentageBasedRecordSampler percentageBasedRecordSampler = this;
        synchronized (percentageBasedRecordSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 9999) {
                this.counter.set(0);
            }
            return result;
        }
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

