/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.httpclient;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class ServiceGroupHttpAsyncClientWrapper
extends CloseableHttpAsyncClient {
    private CloseableHttpAsyncClient original;

    public ServiceGroupHttpAsyncClientWrapper(CloseableHttpAsyncClient original) {
        this.original = original;
    }

    private <T> FutureCallback<T> getServiceGroupWrappedCallback(final FutureCallback<T> callback) {
        final String currentGroupKey = ServiceGroupContext.getCurrentGroupKey();
        FutureCallback wrappedCallback = new FutureCallback<T>(){

            public void completed(T result) {
                ServiceGroupContext.setGroupKey(currentGroupKey);
                try {
                    callback.completed(result);
                }
                finally {
                    ServiceGroupContext.removeGroupKey();
                }
            }

            public void failed(Exception ex) {
                ServiceGroupContext.setGroupKey(currentGroupKey);
                try {
                    callback.failed(ex);
                }
                finally {
                    ServiceGroupContext.removeGroupKey();
                }
            }

            public void cancelled() {
                ServiceGroupContext.setGroupKey(currentGroupKey);
                try {
                    callback.cancelled();
                }
                finally {
                    ServiceGroupContext.removeGroupKey();
                }
            }
        };
        return wrappedCallback;
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.original.execute(requestProducer, responseConsumer, context, this.getServiceGroupWrappedCallback(callback));
    }

    public boolean isRunning() {
        return this.original.isRunning();
    }

    public void start() {
        this.original.start();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.original.execute(requestProducer, responseConsumer, this.getServiceGroupWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.original.execute(target, request, context, this.getServiceGroupWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.original.execute(target, request, this.getServiceGroupWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.original.execute(request, context, this.getServiceGroupWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.original.execute(request, this.getServiceGroupWrappedCallback(callback));
    }

    public void close() throws IOException {
        this.original.close();
    }
}

