/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class PriorityOrderedBeanPostProcessorChecker
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    public int getOrder() {
        return 0;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            this.scanBean(beanName, beanFactory);
        }
    }

    private void scanBean(String beanName, ConfigurableListableBeanFactory beanFactory) {
        Class clazz;
        AbstractBeanDefinition beanDef = (AbstractBeanDefinition)beanFactory.getBeanDefinition(beanName);
        try {
            clazz = beanDef.resolveBeanClass(beanFactory.getBeanClassLoader());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (clazz == null) {
            return;
        }
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)clazz, Configuration.class)) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Bean.class) || !BeanPostProcessor.class.isAssignableFrom(method.getReturnType()) && !SpecifiedBeanPostProcessor.class.isAssignableFrom(method.getReturnType()) && !BeanFactoryPostProcessor.class.isAssignableFrom(method.getReturnType()) || Modifier.isStatic(method.getModifiers()) || clazz.getName().startsWith("org.springframework.")) continue;
                throw new IllegalStateException("the method [" + clazz.getName() + "." + method.getName() + "] generated bean of type [BeanPostProcessor or SpecifiedBeanPostProcessor or BeanFactoryPostProcessor] must be static.");
            }
        }
    }
}

