package cn.com.duibaboot.ext.autoconfigure.grouping.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.springframework.beans.BeansException;

/**
 * 让CloseableHttpAsyncClient支持多场景测试的服务分组
 */
public class ServiceGroupHttpAsyncClientPostProcessor implements SpecifiedBeanPostProcessor<CloseableHttpAsyncClient> {
    @Override
    public Class<CloseableHttpAsyncClient> getBeanType() {
        return CloseableHttpAsyncClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return new ServiceGroupHttpAsyncClientWrapper(bean);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
