/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duiba.wolf.utils.ConcurrentUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.CustomRibbonServerList;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.DevRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.PerfTestRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonPing;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.ServiceGroupRibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.RuntimeRule;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Resource;
import org.apache.http.pool.LeastActiveServerListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.netflix.feign.CustomFeignClientsRegistrar;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonApplicationContextInitializer;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={LeastActiveServerListFilter.class})
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonCustomAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RibbonCustomAutoConfiguration.class);
    @Resource
    private SpringClientFactory springClientFactory;
    @Autowired
    private ObjectProvider<List<RibbonApplicationContextInitializer>> ribbonApplicationContextInitializersProvider;

    @EventListener(value={MainContextRefreshedEvent.class})
    @Order(value=-2147483648)
    public void onMainContextRefreshed() {
        long start = System.currentTimeMillis();
        List list = (List)this.ribbonApplicationContextInitializersProvider.getIfAvailable();
        if (list != null) {
            list.forEach(ribbonApplicationContextInitializer -> ribbonApplicationContextInitializer.onApplicationEvent(null));
        }
        long cost = System.currentTimeMillis() - start;
        logger.info("ribbon context initted in {}ms", (Object)cost);
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> springClientFactoryInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                if (event.getApplicationContext() instanceof EmbeddedWebApplicationContext) {
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    for (String name : enabledFeignClientNames) {
                        RibbonCustomAutoConfiguration.this.springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }

    @Bean
    public IPingStrategy getConcurrentRibbonPingStrategy() {
        return new ConcurrentPingStrategy();
    }

    @Bean
    public ApplicationListener<ContextRefreshedEvent> iLoadBalancerInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                try {
                    ILoadBalancer bean = (ILoadBalancer)event.getApplicationContext().getBean(ILoadBalancer.class);
                    Field pingStrategyField = ReflectionUtils.findField(bean.getClass(), (String)"pingStrategy");
                    if (pingStrategyField != null) {
                        pingStrategyField.setAccessible(true);
                        ReflectionUtils.setField((Field)pingStrategyField, (Object)bean, (Object)RibbonCustomAutoConfiguration.this.getConcurrentRibbonPingStrategy());
                    } else {
                        logger.error("[NOTIFYME]ILoadBalancer\u4e2d\u7684pingStrategy Field\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4f7f\u7528\u5e76\u53d1ping\u7b56\u7565");
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
        };
    }

    @Bean
    @Profile(value={"dev"})
    public DevRibbonServerListFilter devRibbonServerListFilter() {
        return new DevRibbonServerListFilter(true);
    }

    @Bean
    @ConditionalOnProperty(value={"duiba.is.api.gateway"}, havingValue="false", matchIfMissing=true)
    public PerfTestRibbonServerListFilter perfTestRibbonServerListFilter() {
        return new PerfTestRibbonServerListFilter();
    }

    @Bean
    public ServiceGroupRibbonServerListFilter serviceGroupRibbonServerListFilter() {
        return new ServiceGroupRibbonServerListFilter();
    }

    private static class ConcurrentPingStrategy
    implements IPingStrategy,
    DisposableBean {
        private final ExecutorService executor = Executors.newFixedThreadPool(20, (ThreadFactory)new NamedThreadFactory("ribbonPing"));
        private static final Logger logger = LoggerFactory.getLogger(ConcurrentPingStrategy.class);

        private ConcurrentPingStrategy() {
        }

        public boolean[] pingServers(IPing ping, Server[] servers) {
            int numCandidates = servers.length;
            boolean[] results = new boolean[numCandidates];
            if (logger.isDebugEnabled()) {
                logger.debug("LoadBalancer:  PingTask executing [" + numCandidates + "] servers configured");
            }
            if (ping == null) {
                logger.error("IPing is null, will mark all servers as not alive");
                return results;
            }
            ArrayList<Callable<Boolean>> callables = new ArrayList<Callable<Boolean>>();
            for (Server server : servers) {
                callables.add(() -> ping.isAlive(server));
            }
            if (this.executor.isTerminated()) {
                return results;
            }
            try {
                List ret = ConcurrentUtils.submitTasksBlocking((Executor)this.executor, callables);
                int i = 0;
                for (Boolean b : ret) {
                    results[i++] = b;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return results;
        }

        public void destroy() throws Exception {
            this.executor.shutdown();
        }
    }

    private static class CustomPropertiesFactory
    extends PropertiesFactory {
        @Resource
        ApplicationContext context;

        private CustomPropertiesFactory() {
        }

        public String getClassName(Class clazz, String name) {
            if (clazz.equals(IRule.class)) {
                return RuntimeRule.class.getName();
            }
            if (clazz.equals(IPing.class)) {
                return RibbonPing.class.getName();
            }
            if (clazz.equals(ServerList.class)) {
                return CustomRibbonServerList.class.getName();
            }
            return super.getClassName(clazz, name);
        }

        public <C> C get(Class<C> clazz, IClientConfig config, String name) {
            if (!ServerList.class.equals(clazz) && !IRule.class.equals(clazz)) {
                return (C)super.get(clazz, config, name);
            }
            String className = this.getClassName(clazz, name);
            if (StringUtils.hasText((String)className)) {
                try {
                    Class<?> toInstantiate = Class.forName(className);
                    return (C)this.instantiateWithConfig(this.context, toInstantiate, config);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unknown class to load " + className + " for class " + clazz + " named " + name);
                }
            }
            return null;
        }

        <C> C instantiateWithConfig(ApplicationContext context, Class<C> clazz, IClientConfig config) {
            Object result = null;
            try {
                Constructor<C> constructor = clazz.getConstructor(IClientConfig.class);
                result = constructor.newInstance(config);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (result == null) {
                result = BeanUtils.instantiate(clazz);
                if (result instanceof IClientConfigAware) {
                    ((IClientConfigAware)result).initWithNiwsConfig(config);
                }
                if (context != null) {
                    context.getAutowireCapableBeanFactory().autowireBean(result);
                }
            }
            return (C)result;
        }
    }

    @Configuration
    @AutoConfigureBefore(value={RibbonAutoConfiguration.class})
    @ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
    public static class RibbonPropertiesFactoryConfiguration {
        @Bean
        public PropertiesFactory propertiesFactory() {
            return new CustomPropertiesFactory();
        }
    }
}

