/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.FilterBasedRule;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedLeastConnectionRule;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedRandomRule;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedRoundRobinRule;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class RuntimeRule
extends AbstractLoadBalancerRule
implements ApplicationListener<EnvironmentChangeEvent> {
    private static Logger log = LoggerFactory.getLogger(RuntimeRule.class);
    private static final String RIBBON_LOADBALANCE_TYPE_KEY = "duiba.ribbon.loadbalance.type";
    private volatile IRule delegate;
    private IClientConfig clientConfig;
    private List<RibbonServerListFilter> ribbonServerListFilters = Collections.emptyList();
    @Resource
    public ApplicationContext applicationContext;

    @Autowired(required=false)
    public void setRibbonServerListFilters(List<RibbonServerListFilter> ribbonServerListFilters) {
        if (ribbonServerListFilters != null) {
            this.ribbonServerListFilters = ribbonServerListFilters;
        }
    }

    @PostConstruct
    public void init() {
        String loadBalanceType;
        ApplicationContext tempContext = this.applicationContext;
        while (!(tempContext instanceof ConfigurableWebApplicationContext)) {
            tempContext = this.applicationContext.getParent();
        }
        if (tempContext instanceof ConfigurableWebApplicationContext) {
            this.applicationContext = tempContext;
        }
        FilterBasedRule temp = "weightedRoundRobin".equals(loadBalanceType = this.applicationContext.getEnvironment().getProperty(RIBBON_LOADBALANCE_TYPE_KEY, "weightedRoundRobin")) ? new WeightedRoundRobinRule(this.getLoadBalancer(), this.ribbonServerListFilters) : ("weightedRandom".equals(loadBalanceType) ? new WeightedRandomRule(this.getLoadBalancer(), this.ribbonServerListFilters) : ("weightedLeastConnection".equals(loadBalanceType) || "leastactive".equals(loadBalanceType) ? new WeightedLeastConnectionRule(this.getLoadBalancer(), this.ribbonServerListFilters) : new WeightedRoundRobinRule(this.getLoadBalancer(), this.ribbonServerListFilters)));
        temp.initWithNiwsConfig(this.clientConfig);
        this.delegate = temp;
        if (this.applicationContext instanceof ConfigurableWebApplicationContext) {
            ((ConfigurableWebApplicationContext)tempContext).addApplicationListener((ApplicationListener)this);
        } else {
            log.warn("Not found ConfigurableWebApplicationContext, {} will no be refreshable", (Object)RIBBON_LOADBALANCE_TYPE_KEY);
        }
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (event.getKeys() == null || !event.getKeys().contains(RIBBON_LOADBALANCE_TYPE_KEY)) {
            return;
        }
        this.init();
    }

    public Server choose(Object key) {
        Server server = this.delegate.choose(key);
        return server;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        if (this.delegate == null) {
            this.applicationContext = MainApplicationContextHolder.getApplicationContext();
            if (this.applicationContext == null) {
                log.warn("[NOTIFYME]applicationContext is null, will not be here");
                return;
            }
            this.ribbonServerListFilters = new ArrayList(MainApplicationContextHolder.getApplicationContext().getBeansOfType(RibbonServerListFilter.class).values());
            this.init();
        }
        this.delegate.setLoadBalancer(lb);
    }
}

