/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.EnhanceException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.StaticMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ConstructorInter;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstMethodsInter;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstMethodsInterWithOverrideArgs;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.OverrideCallable;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsInter;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsInterWithOverrideArgs;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public abstract class ClassEnhancePluginDefine
extends AbstractClassEnhancePluginDefine {
    public static final String CONTEXT_ATTR_NAME = "_$EnhancedClassField_ws";

    @Override
    protected DynamicType.Builder enhance(String enhanceOriginClassName, DynamicType.Builder newClassBuilder, ClassLoader classLoader) throws PluginException {
        newClassBuilder = this.enhanceClass(enhanceOriginClassName, newClassBuilder, classLoader);
        newClassBuilder = this.enhanceInstance(enhanceOriginClassName, newClassBuilder, classLoader);
        return newClassBuilder;
    }

    private DynamicType.Builder enhanceInstance(String enhanceOriginClassName, DynamicType.Builder newClassBuilder, ClassLoader classLoader) throws PluginException {
        boolean existedMethodsInterceptPoints;
        Object[] constructorInterceptPoints = this.getConstructorsInterceptPoints();
        Object[] instanceMethodsInterceptPoints = this.getInstanceMethodsInterceptPoints();
        boolean existedConstructorInterceptPoint = !ArrayUtils.isEmpty((Object[])constructorInterceptPoints);
        boolean bl = existedMethodsInterceptPoints = !ArrayUtils.isEmpty((Object[])instanceMethodsInterceptPoints);
        if (!existedConstructorInterceptPoint && !existedMethodsInterceptPoints) {
            return newClassBuilder;
        }
        if (existedConstructorInterceptPoint) {
            for (Object constructorInterceptPoint : constructorInterceptPoints) {
                newClassBuilder = newClassBuilder.constructor(constructorInterceptPoint.getConstructorMatcher()).intercept((Implementation)SuperMethodCall.INSTANCE.andThen((Implementation.Composable)MethodDelegation.withDefaultConfiguration().to((Object)new ConstructorInter(constructorInterceptPoint.getConstructorInterceptor(), classLoader))));
            }
        }
        if (existedMethodsInterceptPoints) {
            for (Object instanceMethodsInterceptPoint : instanceMethodsInterceptPoints) {
                String interceptor = instanceMethodsInterceptPoint.getMethodsInterceptor();
                if (StringUtils.isEmpty((String)interceptor)) continue;
                ElementMatcher.Junction junction = ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic()).and(instanceMethodsInterceptPoint.getMethodsMatcher());
                newClassBuilder = instanceMethodsInterceptPoint.isOverrideArgs() ? newClassBuilder.method((ElementMatcher)junction).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(OverrideCallable.class)}).to((Object)new InstMethodsInterWithOverrideArgs(interceptor, classLoader))) : newClassBuilder.method((ElementMatcher)junction).intercept((Implementation)MethodDelegation.withDefaultConfiguration().to((Object)new InstMethodsInter(interceptor, classLoader)));
            }
        }
        return newClassBuilder;
    }

    protected abstract ConstructorInterceptPoint[] getConstructorsInterceptPoints();

    protected abstract InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints();

    private DynamicType.Builder enhanceClass(String enhanceOriginClassName, DynamicType.Builder newClassBuilder, ClassLoader classLoader) throws PluginException {
        StaticMethodsInterceptPoint[] staticMethodsInterceptPoints = this.getStaticMethodsInterceptPoints();
        if (staticMethodsInterceptPoints == null || staticMethodsInterceptPoints.length == 0) {
            return newClassBuilder;
        }
        for (StaticMethodsInterceptPoint staticMethodsInterceptPoint : staticMethodsInterceptPoints) {
            String interceptor = staticMethodsInterceptPoint.getMethodsInterceptor();
            if (StringUtils.isEmpty((String)interceptor)) {
                throw new EnhanceException("no StaticMethodsAroundInterceptor define to enhance class " + enhanceOriginClassName);
            }
            newClassBuilder = staticMethodsInterceptPoint.isOverrideArgs() ? newClassBuilder.method((ElementMatcher)ElementMatchers.isStatic().and(staticMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(OverrideCallable.class)}).to((Object)new StaticMethodsInterWithOverrideArgs(interceptor))) : newClassBuilder.method((ElementMatcher)ElementMatchers.isStatic().and(staticMethodsInterceptPoint.getMethodsMatcher())).intercept((Implementation)MethodDelegation.withDefaultConfiguration().to((Object)new StaticMethodsInter(interceptor)));
        }
        return newClassBuilder;
    }

    protected abstract StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints();
}

