/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.caffeine;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.springframework.util.Assert;

public class CaffeineCacheInterceptor
implements InstanceMethodsAroundInterceptor {
    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        String methodName = method.getName();
        Assert.state(("build".equals(methodName) || "buildAsync".equals(methodName) ? 1 : 0) != 0, (String)"method name must be 'build', will not be here");
        int parameterCount = method.getParameterCount();
        if ("buildAsync".equals(methodName) && parameterCount == 1) {
            AsyncLoadingCache cacheForNormal = (AsyncLoadingCache)ret;
            AsyncLoadingCache cacheForPerfTest = (AsyncLoadingCache)((Callable)zuperCall).call();
            return new AutoRoutingLocalAsyncLoadingCache(cacheForNormal, cacheForPerfTest);
        }
        if ("build".equals(methodName) && parameterCount == 0) {
            Cache cacheForNormal = (Cache)ret;
            Cache cacheForPerfTest = (Cache)((Callable)zuperCall).call();
            return new AutoRoutingLocalCache(cacheForNormal, cacheForPerfTest);
        }
        if ("build".equals(methodName) && parameterCount == 1) {
            LoadingCache cacheForNormal = (LoadingCache)ret;
            LoadingCache cacheForPerfTest = (LoadingCache)((Callable)zuperCall).call();
            return new AutoRoutingLocalLoadingCache(cacheForNormal, cacheForPerfTest);
        }
        throw new IllegalStateException("will never be here");
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    static class AutoRoutingLocalAsyncLoadingCache<K, V>
    implements AsyncLoadingCache<K, V> {
        private AsyncLoadingCache<K, V> cacheForNormal;
        private AsyncLoadingCache<K, V> cacheForPerfTest;

        private AutoRoutingLocalAsyncLoadingCache(AsyncLoadingCache<K, V> cacheForNormal, AsyncLoadingCache<K, V> cacheForPerfTest) {
            this.cacheForNormal = cacheForNormal;
            this.cacheForPerfTest = cacheForPerfTest;
        }

        protected AsyncLoadingCache<K, V> determineCache() {
            return InternalPerfTestContext.isCurrentInPerfTestMode() ? this.cacheForPerfTest : this.cacheForNormal;
        }

        @CheckForNull
        public CompletableFuture<V> getIfPresent(@Nonnull Object key) {
            return this.determineCache().getIfPresent(key);
        }

        @Nonnull
        public CompletableFuture<V> get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
            return this.determineCache().get(key, mappingFunction);
        }

        @Nonnull
        public CompletableFuture<V> get(@Nonnull K key, @Nonnull BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction) {
            return this.determineCache().get(key, mappingFunction);
        }

        @Nonnull
        public CompletableFuture<V> get(@Nonnull K key) {
            return this.determineCache().get(key);
        }

        @Nonnull
        public CompletableFuture<Map<K, V>> getAll(@Nonnull Iterable<? extends K> keys) {
            return this.determineCache().getAll(keys);
        }

        public void put(@Nonnull K key, @Nonnull CompletableFuture<V> valueFuture) {
            this.determineCache().put(key, valueFuture);
        }

        @Nonnull
        public LoadingCache<K, V> synchronous() {
            return this.determineCache().synchronous();
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            AsyncLoadingCache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("readObject", ObjectInputStream.class);
                method.setAccessible(true);
                method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        Object writeReplace() {
            AsyncLoadingCache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class AutoRoutingLocalLoadingCache<K, V>
    extends AutoRoutingLocalCache<K, V>
    implements LoadingCache<K, V> {
        private AutoRoutingLocalLoadingCache(LoadingCache<K, V> cacheForNormal, LoadingCache<K, V> cacheForPerfTest) {
            super((Cache)cacheForNormal, (Cache)cacheForPerfTest);
        }

        @Override
        protected LoadingCache<K, V> determineCache() {
            return (LoadingCache)super.determineCache();
        }

        @CheckForNull
        public V get(@Nonnull K key) {
            return (V)this.determineCache().get(key);
        }

        @Nonnull
        public Map<K, V> getAll(@Nonnull Iterable<? extends K> keys) {
            return this.determineCache().getAll(keys);
        }

        public void refresh(@Nonnull K key) {
            this.determineCache().refresh(key);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            LoadingCache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("readObject", ObjectInputStream.class);
                method.setAccessible(true);
                method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        Object writeReplace() {
            LoadingCache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class AutoRoutingLocalCache<K, V>
    implements Cache<K, V> {
        private Cache<K, V> cacheForNormal;
        private Cache<K, V> cacheForPerfTest;

        private AutoRoutingLocalCache(Cache<K, V> cacheForNormal, Cache<K, V> cacheForPerfTest) {
            this.cacheForNormal = cacheForNormal;
            this.cacheForPerfTest = cacheForPerfTest;
        }

        protected Cache<K, V> determineCache() {
            return InternalPerfTestContext.isCurrentInPerfTestMode() ? this.cacheForPerfTest : this.cacheForNormal;
        }

        @CheckForNull
        public V getIfPresent(@Nonnull Object key) {
            return (V)this.determineCache().getIfPresent(key);
        }

        @CheckForNull
        public V get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
            return (V)this.determineCache().get(key, mappingFunction);
        }

        @Nonnull
        public Map<K, V> getAllPresent(@Nonnull Iterable<?> keys) {
            return this.determineCache().getAllPresent(keys);
        }

        public void put(@Nonnull K key, @Nonnull V value) {
            this.determineCache().put(key, value);
        }

        public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
            this.determineCache().putAll(map);
        }

        public void invalidate(@Nonnull Object key) {
            this.determineCache().invalidate(key);
        }

        public void invalidateAll(@Nonnull Iterable<?> keys) {
            this.determineCache().invalidateAll(keys);
        }

        public void invalidateAll() {
            this.determineCache().invalidateAll();
        }

        public long estimatedSize() {
            return this.determineCache().estimatedSize();
        }

        @Nonnull
        public CacheStats stats() {
            return this.determineCache().stats();
        }

        @Nonnull
        public ConcurrentMap<K, V> asMap() {
            return this.determineCache().asMap();
        }

        public void cleanUp() {
            this.determineCache().cleanUp();
        }

        @Nonnull
        public Policy<K, V> policy() {
            return this.determineCache().policy();
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            Cache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("readObject", ObjectInputStream.class);
                method.setAccessible(true);
                method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        Object writeReplace() {
            Cache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

