/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class SecurityCheckSandbox {
    private final List<DefensivePolicy> policyList;
    private HttpServletRequest request;
    private HttpServletResponse response;

    SecurityCheckSandbox(HttpServletRequest request, HttpServletResponse response, List<DefensivePolicy> policyList) {
        this.policyList = policyList;
        this.request = request;
        this.response = response;
    }

    void doCheck() {
        if (this.policyList == null || this.policyList.isEmpty()) {
            return;
        }
        for (DefensivePolicy policy : this.policyList) {
            this.request = policy.preprocessorRequest(this.request);
            this.response = policy.preprocessorResponse(this.response);
            policy.doDefensive(this.request, this.response);
        }
    }

    void doFilter(FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

