/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterBasedRule
extends ZoneAvoidanceRule {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<RibbonServerListFilter> serverListFilters;

    public FilterBasedRule(List<RibbonServerListFilter> serverListFilters) {
        this.serverListFilters = serverListFilters;
    }

    public Server choose(Object key) {
        DiscoveryEnabledServer server1;
        String isPerfTestSupportted;
        ILoadBalancer lb = this.getLoadBalancer();
        if (lb == null) {
            this.log.warn("no load balancer");
            return null;
        }
        List servers = this.getPredicate().getEligibleServers(lb.getReachableServers(), key);
        if (this.serverListFilters != null) {
            for (RibbonServerListFilter filter2 : this.serverListFilters) {
                servers = filter2.filter(servers, key);
            }
        }
        if (servers.isEmpty()) {
            this.log.info("No available alive server from lb.getReachableServers(), failback to lb.getAllServers()");
            servers = lb.getAllServers();
        }
        if (CollectionUtils.isEmpty((Collection)servers)) {
            return null;
        }
        Server server = this.chooseFromServers(servers, this.getLoadBalancer(), key);
        if (server != null && server instanceof DiscoveryEnabledServer && !"1".equals(isPerfTestSupportted = (String)(server1 = (DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("isPerfTestSupportted")) && InternalPerfTestContext.isCurrentInPerfTestMode()) {
            throw new IllegalStateException("\u8bc6\u522b\u5230\u5f53\u524d\u8bf7\u6c42\u662f\u538b\u6d4b\u6d41\u91cf\uff0c\u4f46\u662f\u8c03\u7528\u7684\u670d\u52a1\u4e0d\u652f\u6301\u6027\u80fd\u538b\u6d4b\uff0c\u653e\u5f03\u672c\u6b21\u8bf7\u6c42\uff0c\u8bf7\u901a\u77e5\u8be5\u670d\u52a1\u8d1f\u8d23\u4eba\u52a0\u5165spring-boot-starter-perftest\u4f9d\u8d56\uff1b\u5c1d\u8bd5\u8c03\u7528\u7684\u670d\u52a1\u7aef\uff1a" + server1.getInstanceInfo().getVIPAddress() + ",ip:" + server1.getInstanceInfo().getIPAddr() + ",port:" + server1.getInstanceInfo().getPort());
        }
        return server;
    }

    protected abstract Server chooseFromServers(List<Server> var1, ILoadBalancer var2, Object var3);

    protected int getTimeBasedWeight(Server server) {
        int weight = 100;
        if (server instanceof DiscoveryEnabledServer) {
            String weightStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("weight");
            weight = NumberUtils.parseInt((String)weightStr, (int)100);
            weight = Math.max(weight, 0);
        }
        if (weight > 0) {
            long uptime;
            long timestamp = 0L;
            int warmUpTimeMillis = 300000;
            if (server instanceof DiscoveryEnabledServer) {
                String tsStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("serverStartUpTime");
                timestamp = NumberUtils.parseLong((String)tsStr, (long)0L);
                timestamp = Math.max(timestamp, 0L);
                String wuStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.warmup.timemillis");
                warmUpTimeMillis = NumberUtils.parseInt((String)wuStr, (int)300000);
                warmUpTimeMillis = Math.max(warmUpTimeMillis, 60000);
            }
            if (timestamp > 0L && (uptime = System.currentTimeMillis() - timestamp) < Integer.MAX_VALUE) {
                if (uptime <= 0L) {
                    weight = 1;
                } else if (uptime > 0L && uptime < (long)warmUpTimeMillis) {
                    weight = this.calculateWarmupWeight((int)uptime, warmUpTimeMillis, weight);
                }
            }
        }
        return weight;
    }

    private int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)((float)uptime / ((float)warmup / (float)weight));
        if (ww < 1) {
            return 1;
        }
        return ww > weight ? weight : ww;
    }
}

