package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import java.util.Arrays;
import java.util.List;

/**
 * 引流回归常量表
 * Created by guoyanfei .
 * 2019-01-29 .
 */
public class FlowReplayConstants {

    public static final int DB_TIME_PROFILE_THRESHOLD = 1000000;

    public static final String DEFAULT_UUID = "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%";

    public static final List<String> COLUMN_NAME_WHITELIST = Arrays.asList("sign");

    /**
     * 引流回归本地目录
     */
    public static final String LOCAL_FLOWREPLAY_DIR = "/data/flowreplay/";

    /**
     * 录制文件的文件名
     */
    public static final String LOCAL_RECORD_FILENAME = "flow_record";

    /**
     * 录制文件的path
     */
    public static final String LOCAL_RECORD_FILEPATH = LOCAL_FLOWREPLAY_DIR + LOCAL_RECORD_FILENAME;

    /**
     * 回放结果的文件名
     */
    public static final String LOCAL_RESULT_FILENAME = "replay_result";

    /**
     * 回放结果的文件path
     */
    public static final String LOCAL_RESULT_FILEPATH = LOCAL_FLOWREPLAY_DIR + LOCAL_RESULT_FILENAME;
    
    /**
     * 回归用的文件名
     */
    public static final String LOCAL_REPLAY_FILENAME = "flow_replay";

    /**
     * 回归用的文件路径
     */
    public static final String LOCAL_REPLAY_FILEPATH = LOCAL_FLOWREPLAY_DIR + LOCAL_REPLAY_FILENAME;

    /**
     * 录制文件的版本
     */
    public static final int RECORD_FILE_VERSION = 1;

    /**
     * 回放结果文件的版本
     */
    public static final int REPLAY_RESULT_FILE_VERSION = 1;

    /**
     * guava cache方法拦截器拦截的方法白名单
     */
    public static final List<String> GUAVA_CACHE_AOP_METHOD = Arrays.asList("getIfPresent",
                                                                            "get",
                                                                            "getAllPresent",
                                                                            "getUnchecked",
                                                                            "getAll");

    /**
     * redis拦截器排除不拦截的方法
     */
    public static final List<String> REDIS_AOP_EXCLUDE_METHOD = Arrays.asList("connect",
                                                                              "auth",
                                                                              "checkIsInMultiOrPipeline",
                                                                              "getDB",
                                                                              "setDataSource",
                                                                              "getClient",
                                                                              "close",
                                                                              "ping",
                                                                              "isConnected",
                                                                              "quit",
                                                                              "disconnect",
                                                                              "resetState",
                                                                              "isConnected",
                                                                              "toString",
                                                                              "hashCode",
                                                                              "equals");


    /**
     * http录制排除的几个uri
     */
    public static final List<String> HTTP_EXCLUDE_URI = Arrays.asList("/flow/record",
                                                                    "/flow/record/stop",
                                                                    "/flow/record/result",
                                                                    "/flow/repaly",
                                                                    "/flow/replay/stop",
                                                                    "/flow/replay/result");

    /**
     * 无法kryo序列化的类，方法拦截器不拦截参数或者返回值类型是这几个类的接口
     */
    public static final List<String> CANNOT_DESERIALIZE_CLASSES = Arrays.asList("com.netflix.loadbalancer.Server",
                                                                                  "org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServer");

}
