package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 回放请求参数类
 * Created by guoyanfei .
 * 2019-01-30 .
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ReplayConfigDto implements Serializable {

    private static final long serialVersionUID = -306367911536384839L;

    /**
     * 默认的回放线程池大小
     */
    private static final int DEFAULT_REPLAY_THREAD_POOL_SIZE = 10;

    /**
     * 报告id
     */
    private Long reportId;

    /**
     * 用例集文件地址
     */
    private String usecaseSetUrl;

    /**
     * 录制开始时间，用于把回放环境的时间设置成录制开始时间
     */
    private Long startTime;

    /**
     * 回放线程池大小
     */
    private Integer replayThreadPoolSize;

    /**
     * ip白名单，指定回放机器可以访问的ip
     */
    private List<String> ipWhitelist;

    /**
     * 屏蔽回放的接口列表
     */
    private List<String> maskedApis;

    public Integer getReplayThreadPoolSize() {
        if (replayThreadPoolSize == null || replayThreadPoolSize < 1) {
            return DEFAULT_REPLAY_THREAD_POOL_SIZE;
        }
        return replayThreadPoolSize;
    }

    /**
     * 参数是否合法
     * @return
     */
    public boolean isLegal() {
        return reportId != null && StringUtils.isNotBlank(usecaseSetUrl) && startTime != null && CollectionUtils.isNotEmpty(ipWhitelist);
    }

    public List<String> getIpWhitelist() {
        return ipWhitelist;
    }
}
